<%
'BindEvents Method @1-D74B2477
Sub BindEvents()
    Set survey_r.CCSEvents("AfterInsert") = GetRef("survey_r_AfterInsert")
    Set survey_r.CCSEvents("BeforeShow") = GetRef("survey_r_BeforeShow")
    Set survey_r.CCSEvents("BeforeInsert") = GetRef("survey_r_BeforeInsert")
    Set CCSEvents("AfterInitialize") = GetRef("Page_AfterInitialize")
End Sub
'End BindEvents Method


Function survey_r_AfterInsert(Sender) 'survey_r_AfterInsert @2-AB5A3357
'Custom Code @13-73254650
' -------------------------
'Invoke survey flow controller after current question is answered and database updated
survey_flow_controller(survey_r.sort_order.Value)
' -------------------------
'End Custom Code
End Function 'Close survey_r_AfterInsert @2-54C34B28


Function survey_r_BeforeShow(Sender) 'survey_r_BeforeShow @2-9680FC80
'Custom Code @15-73254650
' -------------------------
Dim SQL
Dim RecordSet

'When displaying the form populate hidden fields with question data so that it is available after the answer is submitted
'(alternatively this could be handled by creating session variables instead of using hidden fields)
SQL = "SELECT * FROM questions WHERE question_id=" & CCGetFromGet("question_id","")
Set RecordSet = DBsurvey.Execute(SQL)
	If NOT RecordSet.EOF Then 
		survey_r.question_type.Value = CCGetValue(RecordSet, "question_type")
		survey_r.sort_order.Value = CCGetValue(RecordSet, "sort_order")
		survey_r.question_text.Value = CCGetValue(RecordSet, "question_text")
		survey_r.respondent_id.Value = Session("respondent_id")
		'survey_r.question_id.Value = populated automatically by the corresponding URL value
	End If
RecordSet.Close
Set RecordSet = Nothing

'Hide all answer types, then show only the needed one
survey_r.a_radio_panel.Visible = False
survey_r.a_checkbox.Visible = False
survey_r.a_memo.Visible = False
survey_r.a_checklist.Visible = False
survey_r.a_multilist.Visible = False

Select Case survey_r.question_type.Value
	Case 1
		survey_r.a_radio_panel.Visible = True
	Case 2
		survey_r.a_checkbox.Visible = True
	Case 3
		survey_r.a_memo.Visible = True
	Case 4
		survey_r.a_checklist.Visible = True
	Case 5
		survey_r.a_multilist.Visible = True
End Select
' -------------------------
'End Custom Code
End Function 'Close survey_r_BeforeShow @2-54C34B28


Function survey_r_BeforeInsert(Sender) 'survey_r_BeforeInsert @2-F9F6B150
'Custom Code @35-73254650
' -------------------------
survey_r.a_multi_response.Value = Replace(CCGetFromPost("a_checklist", "")," ", "") & Replace(CCGetFromPost("a_multilist", "")," ", "")
' -------------------------
'End Custom Code
End Function 'Close survey_r_BeforeInsert @2-54C34B28


Function Page_AfterInitialize(Sender) 'Page_AfterInitialize @1-5C791CCC
'Custom Code @10-73254650
' -------------------------
'Check if survey_id is valid
'(this can be improved by looking up valid & active survey_id from the database)
If CCGetFromGet("survey_id","") < "1" Then
	Redirect = "status.asp?status_code=invalid"
	Exit Function
End If

'Start a new survey when question_id is unknown
If CCGetFromGet("question_id","") < "1" Then survey_flow_controller(-1)

' -------------------------
'End Custom Code
End Function 'Close Page_AfterInitialize @1-54C34B28



'Survey Flow Controller
'(global subroutine outside standard events, could be moved into Common.asp or an external script)
Sub survey_flow_controller(current_sort)
Dim next_question
Dim current_survey_id
Dim SQL

	current_survey_id = CCGetFromGet("survey_id","")

	If current_sort < 0 Then  '(indicates new survey has been initiated)
		'Check if the respondent has already completed this survey
		If InStr(Request.Cookies("surveys_done") & ",", "," & current_survey_id & ",") Then
			Redirect = "status.asp?status_code=completed"
			Exit Sub   'somewhat ugly exit
		End If

		'Create new user (respondent) in the database
		'NOTE: New user is created every time a person starts survey, while an alternative or additional method would be to track a single user answering multiple surveys
		SQL = "INSERT INTO respondents (survey_id, respondent_ip, date_response_start) VALUES (" &_
		DBsurvey.ToSQL(current_survey_id, ccsInteger) &_
		"," & DBsurvey.ToSQL(request.servervariables("REMOTE_ADDR"), ccsText) &_
		"," & DBsurvey.ToSQL(NOW(), ccsDate) & ")"
		DBsurvey.Execute(SQL)

		'Save the newly created user (respondent) into session variable
		Session("respondent_id") = CCDLookUp("@@IDENTITY", "respondents","",DBsurvey)  'Syntax valid only for MS Access and MS SQL Server
	End If

	'Find next question
	next_question = CCDLookUp("question_id","questions","sort_order > " & current_sort & " AND survey_id=" & current_survey_id & " ORDER BY sort_order", DBsurvey)

	'Create or modify the Redirect
	If next_question Then
		If InStr(Redirect, "question_id=")Then
			Redirect = Replace(Redirect, "question_id=" & CCGetFromGet("question_id",""), "question_id=" & next_question)
		Else
			Redirect = "question.asp?question_id=" & next_question & "&survey_id=" & current_survey_id
		End If
	Else
		'Update respondent's record with the time the survey was completed
		SQL = "UPDATE respondents SET date_response_end= " & DBsurvey.ToSQL(NOW(), ccsDate) &_
		      "WHERE respondent_id= " & Session("respondent_id")
		DBsurvey.Execute(SQL)

  		'Record survey status in respondent's cookie, expiring in 1 day
		Response.Cookies("surveys_done") = Request.Cookies("surveys_done") & "," & current_survey_id
		Response.Cookies("surveys_done").Expires = Date() + 1

		'Thank the respondent
		Redirect = "status.asp?status_code=thanks"
	End If
End Sub

%>